package cn.iinti.majora3.adr

import android.content.Intent
import android.os.Bundle
import android.view.Gravity
import androidx.activity.ComponentActivity
import androidx.activity.compose.setContent
import androidx.compose.foundation.layout.padding
import androidx.compose.material3.Scaffold
import androidx.compose.material3.SnackbarHost
import androidx.compose.material3.SnackbarHostState
import androidx.compose.runtime.CompositionLocalProvider
import androidx.compose.runtime.remember
import androidx.compose.ui.Modifier
import androidx.navigation.compose.rememberNavController
import cn.iinti.majora3.adr.ui.screen.NavGraphs
import cn.iinti.majora3.adr.ui.theme.Majora3Theme
import cn.iinti.majora3.adr.ui.util.LocalSnackbarHost
import com.hjq.permissions.Permission
import com.hjq.permissions.XXPermissions
import com.hjq.window.EasyWindow
import com.hjq.window.draggable.SpringBackWindowDraggableRule
import com.ramcosta.composedestinations.DestinationsNavHost

class MainActivity : ComponentActivity() {

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)

        setContent {
            Majora3Theme {
                val navController = rememberNavController()
                val snackbarHostState = remember { SnackbarHostState() }
                Scaffold(
                    snackbarHost = { SnackbarHost(snackbarHostState) }
                ) { innerPadding ->
                    CompositionLocalProvider(
                        LocalSnackbarHost provides snackbarHostState,
                    ) {
                        DestinationsNavHost(
                            modifier = Modifier.padding(innerPadding),
                            navGraph = NavGraphs.root,
                            navController = navController
                        )
                    }
                }
            }
        }
        showMajoraFloatWindow()
    }

    private var hasShowFloatWindow = false

    /**
     * 设置一个应用外悬浮窗，因为安卓10之后对后台启动activity具有限制
     * https://developer.android.com/guide/components/activities/background-starts
     * <p>
     */
    private fun showMajoraFloatWindow() {
        if (hasShowFloatWindow) {
            return
        }
        XXPermissions.with(this)
            .permission(Permission.SYSTEM_ALERT_WINDOW)
            .request { permission: List<String>, allGranted ->
                hasShowFloatWindow = true
                EasyWindow.with(majora3App).apply {
                    setContentView(R.layout.toast_phone);
                    setWindowDraggableRule(SpringBackWindowDraggableRule())
                    setGravity(Gravity.END or Gravity.BOTTOM)
                    setYOffset(200)
                    setOnClickListenerByView { w, v ->
                        val intent = Intent(majora3App, MainActivity::class.java)
                        intent.addFlags(Intent.FLAG_ACTIVITY_SINGLE_TOP)
                        startActivity(intent)
                    }
                    // 不允许取消，我们目的是常驻左面
                    show()
                }
            }
    }
}