package cn.iinti.majora3.adr

import android.Manifest
import android.app.Notification
import android.app.PendingIntent
import android.app.Service
import android.content.Context
import android.content.Intent
import android.content.pm.PackageManager
import android.content.pm.ServiceInfo
import android.graphics.BitmapFactory
import android.os.IBinder
import android.util.Log


class KeepAliveService : Service() {
    private fun onServiceStartupInternal() {
        //给设备发通知, 就是手机的通知栏的信息
        val launchIntent = Intent(
            this,
            MainActivity::class.java
        )
        val channelId = BuildConfig.APPLICATION_ID
        val builder = Notification.Builder(this, channelId)
        builder.setContentIntent(
            PendingIntent.getActivity(
                this,
                0,
                launchIntent,
                PendingIntent.FLAG_UPDATE_CURRENT or PendingIntent.FLAG_IMMUTABLE
            )
        )
            .setLargeIcon(BitmapFactory.decodeResource(this.resources, R.drawable.ic_launcher))
            .setContentTitle("Majora")
            .setContentText("Majora 代理IP供应服务")
            .setWhen(System.currentTimeMillis())

        val notification = builder.build()
        startForeground(
            channelId.hashCode(),
            notification,
            ServiceInfo.FOREGROUND_SERVICE_TYPE_MEDIA_PLAYBACK
        )
        start = true
    }


    override fun onBind(intent: Intent): IBinder? {
        onServiceStartupInternal()
        return null
    }

    // 返回START_STICKY, 代表如果service进程被kill掉，保留service的状态为开始状态，但不保留递送的intent对象。
    // 随后系统会尝试重新创建service，由于服务状态为开始状态，所以创建服务后一定会调用onStartCommand(Intent,int,int)方法。
    // 如果在此期间没有任何启动命令被传 递到service，那么参数Intent将为null
    override fun onStartCommand(intent: Intent, flags: Int, startId: Int): Int {
        onServiceStartupInternal()
        return START_STICKY
    }

    companion object {
        private var start = false

        fun startService(context: Context) {
            if (start) {
                return
            }
            if (context.checkSelfPermission(Manifest.permission.FOREGROUND_SERVICE)
                == PackageManager.PERMISSION_GRANTED
            ) {
                val intent = Intent(context, KeepAliveService::class.java)
                context.startService(intent)
            } else {
                Log.w(TAG, "can not start KeepAliveService because no permission")
            }
        }
    }
}
