package cn.iinti.majora3.sdk.proto;

import io.netty.buffer.ByteBuf;
import lombok.Getter;

@Getter
public abstract class SessionSignal implements IProto {
    private final int sessionId;

    @Override
    public void writeTo(ByteBuf out) {
        IO.writeInt(out, sessionId);
    }

    private SessionSignal(ByteBuf in) {
        sessionId = IO.readInt(in);
    }

    public SessionSignal(int sessionId) {
        this.sessionId = sessionId;
    }

    public static class SessionClose extends SessionSignal {
        public static final ByteBufCreator<SessionClose> CREATOR =
                new ByteBufCreator<SessionClose>(SessionSignal.SessionClose.class) {

                    @Override
                    public SessionClose create(ByteBuf in) {
                        return new SessionClose(in);
                    }
                };

        private final String reason;

        private SessionClose(ByteBuf in) {
            super(in);
            this.reason = IO.readString(in);
        }

        public SessionClose(int sessionId, String reason) {
            super(sessionId);
            this.reason = reason;
        }

        @Override
        public void writeTo(ByteBuf out) {
            super.writeTo(out);
            IO.writeString(out, reason);
        }
    }

    public static class SessionReady extends SessionSignal {

        public static final ByteBufCreator<SessionReady> CREATOR =
                new ByteBufCreator<SessionReady>(SessionSignal.SessionReady.class) {

                    @Override
                    public SessionReady create(ByteBuf in) {
                        return new SessionReady(in);
                    }
                };

        private SessionReady(ByteBuf in) {
            super(in);
        }

        public SessionReady(int sessionId) {
            super(sessionId);
        }
    }
}
