package cn.iinti.majora3.sdk.proto;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.DefaultByteBufHolder;
import lombok.Getter;


@Getter
public class SessionPayload extends DefaultByteBufHolder implements IProto {

    public static final ByteBufCreator<SessionPayload> CREATOR =
            new ByteBufCreator<SessionPayload>(SessionPayload.class) {

                @Override
                public SessionPayload create(ByteBuf in) {
                    return new SessionPayload(in);
                }
            };
    private final int sessionId;

    private SessionPayload(ByteBuf content) {
        super(IO.readBytes(content));
        this.sessionId = IO.readInt(content);
    }

    @Override
    public void writeTo(ByteBuf out) {
        IO.writeBytes(out, content());
        IO.writeInt(out, sessionId);
    }

    public SessionPayload(ByteBuf content, int sessionId) {
        super(content);
        this.sessionId = sessionId;
    }


    @Override
    public SessionPayload replace(ByteBuf content) {
        return new SessionPayload(content, sessionId);
    }
}
