package cn.iinti.majora3.sdk.proto;


import io.netty.buffer.ByteBuf;
import lombok.RequiredArgsConstructor;

@RequiredArgsConstructor
public class SessionLog implements IProto {
    public static final ByteBufCreator<SessionLog> CREATOR =
            new ByteBufCreator<SessionLog>(SessionLog.class) {

                @Override
                public SessionLog create(ByteBuf in) {
                    return new SessionLog(in);
                }
            };

    private final String sessionId;
    private final long timestamp;
    private final String msg;

    @Override
    public void writeTo(ByteBuf out) {
        IO.writeString(out, sessionId);
        IO.writeLong(out, timestamp);
        IO.writeString(out, msg);
    }

    private SessionLog(ByteBuf in) {
        sessionId = IO.readString(in);
        timestamp = IO.readLong(in);
        msg = IO.readString(in);
    }
}
