package cn.iinti.majora3.sdk.proto;

import io.netty.buffer.ByteBuf;
import lombok.Getter;


@Getter
public class HeartBeat implements IProto {
    public static final ByteBufCreator<HeartBeat> CREATOR =
            new ByteBufCreator<HeartBeat>(HeartBeat.class) {
                @Override
                public HeartBeat create(ByteBuf in) {
                    return new HeartBeat(in);
                }
            };
    /**
     * ping值，以毫秒为单位，int最大可以表达83小时，大约3天时间。
     * 即毫秒值（8字节），取后4字节
     * <p>
     * ping值延时主要用于评估一个代理隧道链路的通信质量，当ping值过高时，可以明确对应IP资源存在问题
     * <ul>
     *     <li>当终端节点和服务器的网络拓扑物理世界过远时（终端网络和服务器网络跨ISP、终端网络和服务器网络跨国家和地区等）</li>
     *     <li>终端隧道流量负载过高，触发TCP流控（如有用户进行大量文件下载操作占满IP带宽资源）</li>
     * </ul>
     */
    private final long pingMillis;

    @Override
    public void writeTo(ByteBuf out) {
        IO.writeLong(out, pingMillis);
    }

    private HeartBeat(ByteBuf in) {
        pingMillis = IO.readLong(in);
    }

    public HeartBeat(long pingMillis) {
        this.pingMillis = (pingMillis);
    }

    @Override
    public String toString() {
        return "pingMillis=" + pingMillis;
    }
}
