package cn.iinti.majora3.sdk.proto;

import android.os.Build;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;

public class Env {
    //majora03
    public static final long MAGIC = 0x6D616A6F72613033L;
    private static final boolean adr = isAndroid();

    public static final String platform = adr ? "Android" : System.getProperty("os.name");
    public static final String osVersion = adr ? "Android" + Build.VERSION.RELEASE : System.getProperty("os.version");

    private static final byte[] magicPayload = createMagicPayload();

    private static byte[] createMagicPayload() {
        ByteBuf magicData = Unpooled.buffer(8).writeLong(MAGIC);
        byte[] bytes = new byte[8];
        magicData.readBytes(bytes);
        return bytes;
    }

    public static ByteBuf magicBuf() {
        return Unpooled.wrappedBuffer(magicPayload);
    }


    private static boolean isAndroid() {
        try {
            Class.forName("android.app.Activity");
            return true;
        } catch (Throwable ignore) {
            return false;
        }
    }
}
