package cn.iinti.majora3.sdk.proto;

import io.netty.buffer.ByteBuf;
import lombok.Getter;

import java.util.Map;

@Getter
public class CtrResp implements IProto {

    public static final ByteBufCreator<CtrResp> CREATOR =
            new ByteBufCreator<CtrResp>(CtrResp.class) {
                @Override
                public CtrResp create(ByteBuf in) {
                    return new CtrResp(in);
                }
            };


    private final int ctrSessionId;

    /**
     * 如果失败，则此字段填入失败消息
     */
    private final String failedMsg;

    /**
     * 如果成功，则此字段填入返回的字典
     */
    private final Map<String, String> response;

    @Override
    public void writeTo(ByteBuf out) {
        IO.writeInt(out, ctrSessionId);
        IO.writeString(out, failedMsg);
        IO.writeMap(out, response);
    }

    private CtrResp(ByteBuf in) {
        ctrSessionId = IO.readInt(in);
        failedMsg = IO.readString(in);
        response = IO.readMap(in);
    }

    public CtrResp(int ctrSessionId, String failedMsg, Map<String, String> response) {
        this.ctrSessionId = ctrSessionId;
        this.failedMsg = failedMsg;
        this.response = response;
    }
}
