package cn.iinti.majora3.sdk.proto;

import io.netty.buffer.ByteBuf;
import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Map;

/**
 * 控制指令请求，请求为一个字典，最后返回一个字典
 */
@AllArgsConstructor
@Getter
public class CtrReq implements IProto {
    public static final ByteBufCreator<CtrReq> CREATOR =
            new ByteBufCreator<CtrReq>(CtrReq.class) {
                @Override
                public CtrReq create(ByteBuf in) {
                    return new CtrReq(in);
                }
            };
    private final int requestSessionId;

    /**
     * 指令类型
     */
    private final String ctr;


    /**
     * 请求参数
     */
    private final Map<String, String> requestMap;

    @Override
    public void writeTo(ByteBuf out) {
        IO.writeInt(out, requestSessionId);
        IO.writeString(out, ctr);
        IO.writeMap(out, requestMap);
    }

    private CtrReq(ByteBuf in) {
        requestSessionId = IO.readInt(in);
        ctr = IO.readString(in);
        requestMap = IO.readMap(in);
    }
}
