package cn.iinti.majora3.sdk.codec;

import cn.iinti.majora3.sdk.proto.*;
import lombok.Getter;

@Getter
public enum PackageType {
    // client
    CLIENT_HEARTBEAT((byte) 0x01, HeartBeat.CREATOR),
    CLIENT_REGISTER((byte) 0x02, ClientRegister.CREATOR),

    // session
    SESSION_INIT_TCP((byte) 0x11, SessionInit.TCP.CREATOR),
    SESSION_INIT_PTY((byte) 0x12, SessionInit.Pty.CREATOR),
    SESSION_READY((byte) 0x13, SessionSignal.SessionReady.CREATOR),
    SESSION_CLOSE((byte) 0x14, SessionSignal.SessionClose.CREATOR),
    SESSION_PAYLOAD((byte) 0x15, SessionPayload.CREATOR),
    SESSION_LOG((byte) 0x16, SessionLog.CREATOR),

    // ctr
    CONTROL_REQ((byte) 0x21, CtrReq.CREATOR),
    CONTROL_RESP((byte) 0x22, CtrResp.CREATOR);

    private final byte code;
    private final IProto.ByteBufCreator<? extends IProto> byteBufCreator;

    PackageType(byte code, IProto.ByteBufCreator<? extends IProto> byteBufCreator) {
        this.code = code;
        this.byteBufCreator = byteBufCreator;
    }


    public static PackageType of(byte code) {
        for (PackageType packageType : values()) {
            if (packageType.code == code) {
                return packageType;
            }
        }
        return null;
    }

    public static PackageType of(Class<? extends IProto> clazz) {
        for (PackageType packageType : values()) {
            if (clazz.equals(packageType.byteBufCreator.getPeerClass())) {
                return packageType;
            }
        }
        return null;
    }
}
