package cn.iinti.majora3.sdk.codec;

import cn.iinti.majora3.sdk.MajoraLogger;
import cn.iinti.majora3.sdk.proto.Env;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.EventLoop;

import java.lang.ref.WeakReference;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class MagicHandSharker extends ChannelInboundHandlerAdapter {
    private final MajoraLogger majoraLogger;

    public MagicHandSharker(Channel channel, MajoraLogger majoraLogger) {
        this.majoraLogger = majoraLogger;
        slowAttackDefence(new WeakReference<>(channel), channel.eventLoop());
    }

    private void slowAttackDefence(WeakReference<Channel> ref, EventLoop eventLoop) {
        eventLoop.schedule(() -> {
            Channel socketChannel = ref.get();
            if (socketChannel == null) {
                return;
            }
            MagicHandSharker magicHandSharker = socketChannel.pipeline().get(MagicHandSharker.class);
            if (magicHandSharker == null) {
                return;
            }
            majoraLogger.log(() -> "the client not got server response after 30s,this maybe slow attack");
            socketChannel.pipeline().fireExceptionCaught(
                    new TimeoutException("the client not got server response after 30s,this maybe slow attack")
            );
        }, 30, TimeUnit.SECONDS);
    }

    @Override
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (!(msg instanceof ByteBuf)) {
            throw new MajoraCodeC.CodeCError("must be byteBuf");
        }

        ByteBuf byteBuf = (ByteBuf) msg;
        if (byteBuf.readableBytes() < 8) {
            majoraLogger.log(() -> "magic handle ,readableBytes less 8");
            // pending
            return;
        }
        long magic = byteBuf.readLong();
        if (magic != Env.MAGIC) {
            throw new MajoraCodeC.CodeCError("error magic,expect " + Env.MAGIC + " actual " + magic);
        }

        // passed
        ctx.pipeline().remove(this);
        if (majoraLogger.enable()) {
            String logMsg = "magic handle finished,fire next read pipeline" + ctx.pipeline().names();
            majoraLogger.log(() -> logMsg);
        }
        // trigger CodeC
        ctx.fireChannelRead(byteBuf);
    }
}
