package cn.iinti.majora3.sdk.client;

import cn.iinti.majora3.sdk.proto.SessionInit;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.channel.*;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.util.concurrent.DefaultThreadFactory;

public class TCPSessionFactory implements SessionManager.SessionFactory<SessionInit.TCP> {

    private static final NioEventLoopGroup workerGroup = new NioEventLoopGroup(
            0, new DefaultThreadFactory("majora-upstream")
    );

    @Override
    public ChannelFuture createSession(MajoraClient client, SessionInit.TCP sessionInit, SimpleChannelInboundHandler<ByteBuf> channelHandler) {
        Bootstrap bootstrap = new Bootstrap().group(workerGroup)
                .channel(NioSocketChannel.class)
                .option(ChannelOption.CONNECT_TIMEOUT_MILLIS, sessionInit.getOpenTimeout())
                .handler(new ChannelInitializer<SocketChannel>() {

                    @Override
                    public void initChannel(SocketChannel ch) {
                        ch.pipeline().addLast(channelHandler);
                    }
                });
        return bootstrap.connect(sessionInit.getHost(), sessionInit.getPort());
    }
}
