package cn.iinti.majora3.sdk.client;


import cn.iinti.majora3.sdk.MajoraLogger;
import lombok.Getter;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ClusterMajoraClient {
    @Getter
    private final String clientId;
    private final List<MajoraClient> majoraClients = new ArrayList<>();

    public ClusterMajoraClient(String clientId, String serverList) {
        this.clientId = clientId;
        Set<String> duplicate = new HashSet<>();
        for (String serverConfig : serverList.trim().split(",")) {
            serverConfig = serverConfig.trim();
            if (duplicate.contains(serverConfig)) {
                continue;
            }
            duplicate.add(serverConfig);

            String[] hostAndPort = serverConfig.split(":");
            majoraClients.add(new MajoraClient(hostAndPort[0], Integer.parseInt(hostAndPort[1]), clientId));
        }
    }

    public ClusterMajoraClient start() {
        majoraClients.forEach(MajoraClient::start);
        return this;
    }

    public ClusterMajoraClient restart() {
        majoraClients.forEach(MajoraClient::reConnect);
        return this;
    }

    public ClusterMajoraClient setLogCodec(boolean enable) {
        majoraClients.forEach((majoraClient -> majoraClient.setLogCodec(enable)));
        return this;
    }

    public ClusterMajoraClient setEndpointGroup(String group) {
        majoraClients.forEach(majoraClient -> majoraClient.setEndpointGroup(group));
        return this;
    }

    public ClusterMajoraClient setLogger(MajoraLogger logger) {
        majoraClients.forEach(majoraClient -> majoraClient.setLogger(logger));
        return this;
    }
}
