package cn.iinti.majora3.sdk.client;

import cn.iinti.majora3.sdk.FailedChannel;
import cn.iinti.majora3.sdk.proto.SessionInit;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.*;
import io.netty.channel.embedded.EmbeddedChannel;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public abstract class BIOStreamSessionFactory<T extends SessionInit> implements SessionManager.SessionFactory<T> {

    @Override
    public ChannelFuture createSession(MajoraClient client,T sessionInit, SimpleChannelInboundHandler<ByteBuf> channelHandler) {
        IOPair ioPair;
        try {
            ioPair = create(sessionInit);
        } catch (Throwable e) {
            return FailedChannel.newFailedChannel(e);
        }

        EmbeddedChannel embeddedChannel = new EmbeddedChannel(channelHandler, new ChannelOutboundHandlerAdapter() {
            @Override
            public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
                if (msg instanceof ByteBuf) {
                    // todo 这里是BIO
                    ByteBuf byteBuf = (ByteBuf) msg;
                    try {
                        byteBuf.readBytes(ioPair.outputStream, byteBuf.readableBytes());
                        promise.trySuccess();
                    } catch (Throwable e) {
                        promise.setFailure(e);
                    }
                    return;
                }
                super.write(ctx, msg, promise);
            }
        });
        new Thread(() -> {
            while (true) {
                try {
                    byte[] bytes = new byte[4096];
                    int count = ioPair.inputStream.read(bytes);
                    if (count < 0) {
                        embeddedChannel.finish();
                        break;
                    }
                    embeddedChannel.writeInbound(Unpooled.wrappedBuffer(bytes, 0, count));
                } catch (IOException e) {
                    embeddedChannel.pipeline().fireExceptionCaught(e);
                    embeddedChannel.finish();
                    break;
                }
            }
        }).start();
        return new DefaultChannelPromise(embeddedChannel).setSuccess();
    }

    protected abstract IOPair create(T sessionInit) throws Throwable;


    public static class IOPair {
        private final InputStream inputStream;
        private final OutputStream outputStream;

        public IOPair(InputStream inputStream, OutputStream outputStream) {
            this.inputStream = inputStream;
            this.outputStream = outputStream;
        }
    }
}
