package cn.iinti.majora3.sdk;

import java.util.function.Supplier;

public interface MajoraLogger {
    default void log(Supplier<String> msg) {

    }

    default void log(Supplier<String> msg, Throwable e) {

    }

    default boolean enable() {
        return false;
    }

    MajoraLogger nop = new MajoraLogger() {
    };

    MajoraLogger consoleLog = new MajoraLogger() {
        @Override
        public void log(Supplier<String> msg) {
            System.out.println(msg.get());
        }

        @Override
        public void log(Supplier<String> msg, Throwable e) {
            System.out.println(msg.get());
            if (e != null) {
                e.printStackTrace(System.err);
            }
        }

        @Override
        public boolean enable() {
            return true;
        }
    };
}
