/*
 * Decompiled with CFR 0.152.
 */
package cn.iinti.majora3.sdk.proto;

import cn.iinti.majora3.sdk.proto.IProto;
import io.netty.buffer.ByteBuf;

public abstract class SessionInit
implements IProto {
    private int sessionId;
    private final int openTimeout;
    private final String sessionTraceId;

    private SessionInit(ByteBuf in) {
        this.sessionId = IProto.IO.readInt(in);
        this.openTimeout = IProto.IO.readInt(in);
        this.sessionTraceId = IProto.IO.readString(in);
    }

    @Override
    public void writeTo(ByteBuf out) {
        IProto.IO.writeInt(out, this.sessionId);
        IProto.IO.writeInt(out, this.openTimeout);
        IProto.IO.writeString(out, this.sessionTraceId);
    }

    public abstract String desc();

    public int getSessionId() {
        return this.sessionId;
    }

    public int getOpenTimeout() {
        return this.openTimeout;
    }

    public String getSessionTraceId() {
        return this.sessionTraceId;
    }

    public void setSessionId(int sessionId) {
        this.sessionId = sessionId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SessionInit)) {
            return false;
        }
        SessionInit other = (SessionInit)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getSessionId() != other.getSessionId()) {
            return false;
        }
        if (this.getOpenTimeout() != other.getOpenTimeout()) {
            return false;
        }
        String this$sessionTraceId = this.getSessionTraceId();
        String other$sessionTraceId = other.getSessionTraceId();
        return !(this$sessionTraceId == null ? other$sessionTraceId != null : !this$sessionTraceId.equals(other$sessionTraceId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SessionInit;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getSessionId();
        result = result * 59 + this.getOpenTimeout();
        String $sessionTraceId = this.getSessionTraceId();
        result = result * 59 + ($sessionTraceId == null ? 43 : $sessionTraceId.hashCode());
        return result;
    }

    public String toString() {
        return "SessionInit(sessionId=" + this.getSessionId() + ", openTimeout=" + this.getOpenTimeout() + ", sessionTraceId=" + this.getSessionTraceId() + ")";
    }

    public SessionInit(int sessionId, int openTimeout, String sessionTraceId) {
        this.sessionId = sessionId;
        this.openTimeout = openTimeout;
        this.sessionTraceId = sessionTraceId;
    }

    public static class Pty
    extends SessionInit {
        public static final IProto.ByteBufCreator<Pty> CREATOR = new IProto.ByteBufCreator<Pty>(Pty.class){

            @Override
            public Pty create(ByteBuf in) {
                return new Pty(in);
            }
        };

        public Pty(ByteBuf in) {
            super(in);
        }

        public Pty(int openTimeout, String sessionTraceId) {
            super(-1, openTimeout, sessionTraceId);
        }

        @Override
        public String desc() {
            return this.getSessionId() + " pty";
        }
    }

    public static class TCP
    extends SessionInit {
        public static final IProto.ByteBufCreator<TCP> CREATOR = new IProto.ByteBufCreator<TCP>(TCP.class){

            @Override
            public TCP create(ByteBuf in) {
                return new TCP(in);
            }
        };
        private final String host;
        private final int port;

        public TCP(int openTimeout, String sessionTraceId, String host, int port) {
            super(-1, openTimeout, sessionTraceId);
            this.host = host;
            this.port = port;
        }

        private TCP(ByteBuf in) {
            super(in);
            this.host = IProto.IO.readString(in);
            this.port = in.readInt();
        }

        @Override
        public void writeTo(ByteBuf out) {
            super.writeTo(out);
            IProto.IO.writeString(out, this.host);
            IProto.IO.writeInt(out, this.port);
        }

        @Override
        public String desc() {
            return this.getSessionId() + " tcp from " + this.host + ":" + this.port;
        }

        public String getHost() {
            return this.host;
        }

        public int getPort() {
            return this.port;
        }
    }
}

