/*
 * Decompiled with CFR 0.152.
 */
package cn.iinti.majora3.sdk.proto;

import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;

public interface IProto {
    public void writeTo(ByteBuf var1);

    public static class IO {
        static void writeString(ByteBuf out, String str) {
            if (str == null) {
                str = "";
            }
            byte[] bytes = str.getBytes(StandardCharsets.UTF_8);
            out.writeInt(bytes.length);
            out.writeBytes(bytes);
        }

        static String readString(ByteBuf in) {
            int len = in.readInt();
            byte[] bytes = new byte[len];
            in.readBytes(bytes);
            return new String(bytes, StandardCharsets.UTF_8);
        }

        static void writeBytes(ByteBuf out, ByteBuf data) {
            out.writeInt(data.readableBytes());
            out.writeBytes(data);
        }

        static ByteBuf readBytes(ByteBuf in) {
            int len = in.readInt();
            return in.readBytes(len);
        }

        static void writeMap(ByteBuf out, Map<String, String> map) {
            if (map == null) {
                out.writeInt(0);
                return;
            }
            out.writeInt(map.size());
            for (Map.Entry<String, String> entry : map.entrySet()) {
                IO.writeString(out, entry.getKey());
                IO.writeString(out, entry.getValue());
            }
        }

        static Map<String, String> readMap(ByteBuf in) {
            int len = in.readInt();
            HashMap<String, String> map = new HashMap<String, String>();
            for (int i = 0; i < len; ++i) {
                map.put(IO.readString(in), IO.readString(in));
            }
            return map;
        }

        static void writeInt(ByteBuf out, int value) {
            out.writeInt(value);
        }

        static int readInt(ByteBuf in) {
            return in.readInt();
        }

        static void writeLong(ByteBuf out, long value) {
            out.writeLong(value);
        }

        static long readLong(ByteBuf in) {
            return in.readLong();
        }

        static void writeBoolean(ByteBuf out, boolean value) {
            out.writeBoolean(value);
        }

        static boolean readBoolean(ByteBuf in) {
            return in.readBoolean();
        }
    }

    public static abstract class ByteBufCreator<T extends IProto> {
        private final Class<T> peerClass;

        public ByteBufCreator(Class<T> peerClass) {
            this.peerClass = peerClass;
        }

        public abstract T create(ByteBuf var1);

        public Class<T> getPeerClass() {
            return this.peerClass;
        }
    }
}

