/*
 * Decompiled with CFR 0.152.
 */
package cn.iinti.majora3.sdk.proto;

import android.os.Build;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;

public class Env {
    public static final long MAGIC = 7881697849767964723L;
    private static final boolean adr = Env.isAndroid();
    public static final String platform = adr ? "Android" : System.getProperty("os.name");
    public static final String osVersion = adr ? "Android" + Build.VERSION.RELEASE : System.getProperty("os.version");
    private static final byte[] magicPayload = Env.createMagicPayload();

    private static byte[] createMagicPayload() {
        ByteBuf magicData = Unpooled.buffer((int)8).writeLong(7881697849767964723L);
        byte[] bytes = new byte[8];
        magicData.readBytes(bytes);
        return bytes;
    }

    public static ByteBuf magicBuf() {
        return Unpooled.wrappedBuffer((byte[])magicPayload);
    }

    private static boolean isAndroid() {
        try {
            Class.forName("android.app.Activity");
            return true;
        }
        catch (Throwable ignore) {
            return false;
        }
    }
}

