/*
 * Decompiled with CFR 0.152.
 */
package cn.iinti.majora3.sdk.codec;

import cn.iinti.majora3.sdk.proto.ClientRegister;
import cn.iinti.majora3.sdk.proto.CtrReq;
import cn.iinti.majora3.sdk.proto.CtrResp;
import cn.iinti.majora3.sdk.proto.HeartBeat;
import cn.iinti.majora3.sdk.proto.IProto;
import cn.iinti.majora3.sdk.proto.SessionInit;
import cn.iinti.majora3.sdk.proto.SessionLog;
import cn.iinti.majora3.sdk.proto.SessionPayload;
import cn.iinti.majora3.sdk.proto.SessionSignal;

public enum PackageType {
    CLIENT_HEARTBEAT(1, HeartBeat.CREATOR),
    CLIENT_REGISTER(2, ClientRegister.CREATOR),
    SESSION_INIT_TCP(17, SessionInit.TCP.CREATOR),
    SESSION_INIT_PTY(18, SessionInit.Pty.CREATOR),
    SESSION_READY(19, SessionSignal.SessionReady.CREATOR),
    SESSION_CLOSE(20, SessionSignal.SessionClose.CREATOR),
    SESSION_PAYLOAD(21, SessionPayload.CREATOR),
    SESSION_LOG(22, SessionLog.CREATOR),
    CONTROL_REQ(33, CtrReq.CREATOR),
    CONTROL_RESP(34, CtrResp.CREATOR);

    private final byte code;
    private final IProto.ByteBufCreator<? extends IProto> byteBufCreator;

    private PackageType(byte code, IProto.ByteBufCreator<? extends IProto> byteBufCreator) {
        this.code = code;
        this.byteBufCreator = byteBufCreator;
    }

    public static PackageType of(byte code) {
        for (PackageType packageType : PackageType.values()) {
            if (packageType.code != code) continue;
            return packageType;
        }
        return null;
    }

    public static PackageType of(Class<? extends IProto> clazz) {
        for (PackageType packageType : PackageType.values()) {
            if (!clazz.equals(packageType.byteBufCreator.getPeerClass())) continue;
            return packageType;
        }
        return null;
    }

    public byte getCode() {
        return this.code;
    }

    public IProto.ByteBufCreator<? extends IProto> getByteBufCreator() {
        return this.byteBufCreator;
    }
}

