/*
 * Decompiled with CFR 0.152.
 */
package cn.iinti.majora3.sdk.codec;

import cn.iinti.majora3.sdk.MajoraLogger;
import cn.iinti.majora3.sdk.codec.PackageType;
import cn.iinti.majora3.sdk.proto.IProto;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageCodec;
import io.netty.util.internal.StringUtil;
import java.util.List;

public class MajoraCodeC
extends ByteToMessageCodec<IProto> {
    private final MajoraLogger codeCLogger;
    private final int encryptXor;

    public MajoraCodeC(MajoraLogger codeCLogger, int encryptXor) {
        this.codeCLogger = codeCLogger;
        this.encryptXor = encryptXor;
    }

    public static String formatByteBuf(ChannelHandlerContext ctx, String eventName, ByteBuf msg) {
        int length;
        String chStr;
        String string = chStr = ctx == null ? "debug" : ctx.channel().toString();
        if (msg == null) {
            msg = Unpooled.EMPTY_BUFFER;
        }
        if ((length = msg.readableBytes()) == 0) {
            return chStr + ' ' + eventName + ": 0B";
        }
        int outputLength = chStr.length() + 1 + eventName.length() + 2 + 10 + 1;
        int rows = length / 16 + (length % 15 == 0 ? 0 : 1) + 4;
        int hexDumpLength = 2 + rows * 80;
        StringBuilder buf = new StringBuilder(outputLength += hexDumpLength);
        buf.append(chStr).append(' ').append(eventName).append(": ").append(length).append('B');
        buf.append(StringUtil.NEWLINE);
        ByteBufUtil.appendPrettyHexDump((StringBuilder)buf, (ByteBuf)msg);
        return buf.toString();
    }

    private static void xor(ByteBuf payload, int len, int xor) {
        int value;
        int i;
        int intIndex = len & 0xFFFFFFFC;
        for (i = 0; i < intIndex; i += 4) {
            value = payload.getInt(i);
            payload.setInt(i, value ^ xor);
        }
        while (i < len) {
            value = payload.getByte(i);
            payload.setByte(i, value ^ xor);
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void encode(ChannelHandlerContext ctx, IProto msg, ByteBuf out) throws CodeCError {
        PackageType packageType = PackageType.of(msg.getClass());
        if (packageType == null) {
            throw new CodeCError("can not resolve PackageType of " + msg.getClass());
        }
        byte typeCode = packageType.getCode();
        out.writeByte((int)typeCode);
        ByteBuf payloadContent = ctx.alloc().buffer();
        try {
            msg.writeTo(payloadContent);
            out.writeInt(payloadContent.readableBytes());
            MajoraCodeC.xor(payloadContent, payloadContent.readableBytes(), this.encryptXor);
            out.writeBytes(payloadContent);
        }
        finally {
            payloadContent.release();
        }
        if (this.codeCLogger.enable()) {
            String logMsg = MajoraCodeC.formatByteBuf(ctx, "majora encode data", out);
            this.codeCLogger.log(() -> logMsg);
        }
    }

    private boolean decodeOnce(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        byte typeCode = in.readByte();
        PackageType packageType = PackageType.of(typeCode);
        if (packageType == null) {
            throw new CodeCError("unknown package type: " + typeCode);
        }
        int payloadLength = in.readInt();
        if (in.readableBytes() < payloadLength) {
            return false;
        }
        ByteBuf content = ctx.alloc().buffer(payloadLength);
        in.readBytes(content, payloadLength);
        MajoraCodeC.xor(content, payloadLength, this.encryptXor);
        this.codeCLogger.log(() -> "decoder Got: " + (Object)((Object)packageType));
        out.add(packageType.getByteBufCreator().create(content));
        content.release();
        return true;
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        String logMsg;
        if (this.codeCLogger.enable()) {
            logMsg = MajoraCodeC.formatByteBuf(ctx, "majora decode data", in);
            this.codeCLogger.log(() -> logMsg);
        }
        while (in.isReadable() && in.readableBytes() >= 5) {
            in.markReaderIndex();
            if (this.decodeOnce(ctx, in, out)) continue;
            if (this.codeCLogger.enable()) {
                logMsg = "not enough bytes to read: " + in;
                this.codeCLogger.log(() -> logMsg);
            }
            in.resetReaderIndex();
            break;
        }
    }

    public static class CodeCError
    extends Exception {
        public CodeCError(String message) {
            super(message);
        }
    }
}

