/*
 * Decompiled with CFR 0.152.
 */
package cn.iinti.majora3.sdk.client;

import cn.iinti.majora3.sdk.client.MajoraClient;
import cn.iinti.majora3.sdk.client.MajoraConnection;
import cn.iinti.majora3.sdk.client.TCPSessionFactory;
import cn.iinti.majora3.sdk.codec.PackageType;
import cn.iinti.majora3.sdk.proto.IProto;
import cn.iinti.majora3.sdk.proto.SessionInit;
import cn.iinti.majora3.sdk.proto.SessionPayload;
import cn.iinti.majora3.sdk.proto.SessionSignal;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.HashMap;
import java.util.Map;

public class SessionManager {
    private static final Map<PackageType, SessionFactory<?>> factories = new HashMap();
    private final MajoraClient majoraClient;
    private final MajoraConnection mConnection;
    private final Map<Integer, SessionHolder> sessions = new HashMap<Integer, SessionHolder>();

    public static void registerSessionFactory(PackageType packageType, SessionFactory<?> factory) {
        Class<? extends IProto> peerClass = packageType.getByteBufCreator().getPeerClass();
        if (!SessionInit.class.isAssignableFrom(peerClass)) {
            throw new IllegalArgumentException("Invalid peer class: " + peerClass.getName());
        }
        factories.put(packageType, factory);
    }

    public static boolean supportSession(PackageType packageType) {
        return factories.containsKey((Object)packageType);
    }

    public SessionManager(MajoraClient majoraClient, MajoraConnection mConnection) {
        this.majoraClient = majoraClient;
        this.mConnection = mConnection;
    }

    private void writeSessionCreateFailed(int sessionId, String reason) {
        SessionSignal.SessionClose sessionClose = new SessionSignal.SessionClose(sessionId, reason);
        this.mConnection.writeToMajora(sessionClose);
    }

    public void onInboundStreamClose(int sessionId) {
        this.majoraClient.doOnMainThead(() -> {
            SessionHolder sessionHolder = this.sessions.remove(sessionId);
            if (sessionHolder == null) {
                return;
            }
            sessionHolder.channel.close();
        });
    }

    public void onInboundStreamData(SessionPayload sessionPayload) {
        SessionHolder sessionHolder = this.sessions.get(sessionPayload.getSessionId());
        if (sessionHolder == null) {
            this.majoraClient.getLogger().log(() -> "Got none existing SessionPayload from: " + sessionPayload.getSessionId());
            return;
        }
        sessionHolder.channel.writeAndFlush((Object)sessionPayload.content().retain());
    }

    public void destroy() {
        this.majoraClient.doOnMainThead(() -> {
            for (SessionHolder value : this.sessions.values()) {
                value.channel.close();
            }
            this.sessions.clear();
        });
    }

    public <T extends SessionInit> void createSession(final MajoraClient client, final T sessionInit) {
        final int sessionId = sessionInit.getSessionId();
        SessionFactory<T> sessionFactory = this.findSessionFactory(sessionInit);
        if (sessionFactory == null) {
            this.writeSessionCreateFailed(sessionId, "can not handle this session because there is no session factory registered:" + sessionInit.getClass());
            return;
        }
        ChannelFuture channelFuture = sessionFactory.createSession(client, sessionInit, new SimpleChannelInboundHandler<ByteBuf>(){

            protected void channelRead0(ChannelHandlerContext ctx, ByteBuf msg) {
                SessionHolder sessionHolder = (SessionHolder)SessionManager.this.sessions.get(sessionId);
                if (sessionHolder == null) {
                    client.getLogger().log(() -> "wtf, no session factory for " + sessionInit.getClass().getName());
                    ctx.close();
                    return;
                }
                sessionHolder.onUpstreamSessionData(msg.retain());
            }
        });
        channelFuture.addListener((GenericFutureListener)((ChannelFutureListener)future -> {
            if (!future.isSuccess()) {
                this.majoraClient.getLogger().log(() -> "create session failed:" + sessionInit.desc(), future.cause());
                this.writeSessionCreateFailed(sessionId, "create session failed:" + future.cause());
                return;
            }
            this.majoraClient.getLogger().log(() -> "session create:" + sessionInit.desc());
            this.majoraClient.doOnMainThead(() -> {
                Channel channel = future.channel();
                this.sessions.put(sessionId, new SessionHolder(sessionId, channel));
                this.mConnection.writeToMajora(new SessionSignal.SessionReady(sessionId));
                channel.closeFuture().addListener((GenericFutureListener)((ChannelFutureListener)future1 -> this.majoraClient.doOnMainThead(() -> {
                    this.majoraClient.getLogger().log(() -> "session closed:" + sessionInit.desc());
                    SessionHolder sessionHolder = this.sessions.remove(sessionId);
                    if (sessionHolder != null) {
                        sessionHolder.onUpstreamSessionClose("upstream remote session closed");
                    }
                })));
            });
        }));
    }

    private <T extends SessionInit> SessionFactory<T> findSessionFactory(T sessionInit) {
        for (Map.Entry<PackageType, SessionFactory<?>> entry : factories.entrySet()) {
            Class<? extends IProto> peerClass = entry.getKey().getByteBufCreator().getPeerClass();
            if (!peerClass.isAssignableFrom(sessionInit.getClass())) continue;
            return entry.getValue();
        }
        return null;
    }

    static {
        SessionManager.registerSessionFactory(PackageType.SESSION_INIT_TCP, new TCPSessionFactory());
    }

    public class SessionHolder {
        protected final int sessionId;
        protected final Channel channel;

        protected SessionHolder(int sessionId, Channel channel) {
            this.sessionId = sessionId;
            this.channel = channel;
        }

        void onUpstreamSessionData(ByteBuf upstreamPayload) {
            SessionPayload sessionPayload = new SessionPayload(upstreamPayload, this.sessionId);
            SessionManager.this.mConnection.writeToMajora(sessionPayload);
        }

        void onUpstreamSessionClose(String reason) {
            SessionSignal.SessionClose sessionClose = new SessionSignal.SessionClose(this.sessionId, reason);
            SessionManager.this.mConnection.writeToMajora(sessionClose);
        }

        public int getSessionId() {
            return this.sessionId;
        }
    }

    public static interface SessionFactory<T extends SessionInit> {
        public ChannelFuture createSession(MajoraClient var1, T var2, SimpleChannelInboundHandler<ByteBuf> var3);
    }
}

