/*
 * Decompiled with CFR 0.152.
 */
package cn.iinti.majora3.sdk.client;

import cn.iinti.majora3.sdk.MajoraLogger;
import cn.iinti.majora3.sdk.client.CtrManager;
import cn.iinti.majora3.sdk.client.MajoraClient;
import cn.iinti.majora3.sdk.client.SessionManager;
import cn.iinti.majora3.sdk.codec.MagicHandSharker;
import cn.iinti.majora3.sdk.codec.MajoraCodeC;
import cn.iinti.majora3.sdk.codec.PackageType;
import cn.iinti.majora3.sdk.proto.ClientRegister;
import cn.iinti.majora3.sdk.proto.CtrReq;
import cn.iinti.majora3.sdk.proto.Env;
import cn.iinti.majora3.sdk.proto.HeartBeat;
import cn.iinti.majora3.sdk.proto.IProto;
import cn.iinti.majora3.sdk.proto.SessionInit;
import cn.iinti.majora3.sdk.proto.SessionPayload;
import cn.iinti.majora3.sdk.proto.SessionSignal;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.timeout.IdleStateEvent;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.Random;

public class MajoraConnection
extends SimpleChannelInboundHandler<IProto> {
    private final String host;
    private final int port;
    private final int connectionTimeout;
    private final int encryptXor = new Random().nextInt();
    private final MajoraClient majoraClient;
    private final MajoraLogger logger;
    private final boolean logCodeC;
    private final NioEventLoopGroup workerGroup;
    private final ConnectionListener connectionListener;
    private final Channel majoraServerChannel;
    private final SessionManager sessionManager;
    private final CtrManager ctrManager;
    private boolean connectedInvoked = false;
    private boolean disconnectInvoked = false;

    public MajoraConnection(String host, int port, int connectionTimeout, MajoraClient majoraClient, NioEventLoopGroup clientLoopGroup, ConnectionListener listener, boolean logCodeC) {
        this.host = host;
        this.port = port;
        this.logCodeC = logCodeC;
        this.connectionTimeout = connectionTimeout;
        this.majoraClient = majoraClient;
        this.logger = majoraClient.getLogger();
        this.workerGroup = clientLoopGroup;
        this.connectionListener = listener;
        this.sessionManager = new SessionManager(majoraClient, this);
        this.ctrManager = new CtrManager(majoraClient, this);
        this.majoraServerChannel = this.connect();
    }

    private Channel connect() {
        Bootstrap bootstrap = (Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group((EventLoopGroup)this.workerGroup)).channel(NioSocketChannel.class)).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)this.connectionTimeout)).handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            public void initChannel(SocketChannel ch) {
                MajoraLogger majoraLogger = MajoraConnection.this.logCodeC ? MajoraConnection.this.logger : MajoraLogger.nop;
                IdleStateHandler idleStateHandler = new IdleStateHandler(42, 0, 0);
                ch.pipeline().addLast(new ChannelHandler[]{idleStateHandler, new MagicHandSharker((Channel)ch, majoraLogger), new MajoraCodeC(majoraLogger, MajoraConnection.this.encryptXor), MajoraConnection.this});
                ch.closeFuture().addListener((GenericFutureListener)((ChannelFutureListener)future -> {
                    MajoraConnection.this.logger.log(() -> "server connection closed");
                    MajoraConnection.this.invokeOnDisconnected();
                    MajoraConnection.this.sessionManager.destroy();
                }));
            }
        });
        this.logger.log(() -> "begin to connect to " + this.host + ":" + this.port);
        ChannelFuture channelFuture = bootstrap.connect(this.host, this.port);
        channelFuture.addListener((GenericFutureListener)((ChannelFutureListener)future -> {
            if (!future.isSuccess()) {
                this.logger.log(() -> "connect to " + this.host + ":" + this.port + " failed ", future.cause());
                this.invokeOnDisconnected();
                return;
            }
            this.logger.log(() -> "connect to " + this.host + ":" + this.port + " success");
            this.registerClient(channelFuture.channel());
        }));
        return channelFuture.channel();
    }

    private void registerClient(Channel channel) {
        channel.write((Object)Env.magicBuf());
        ByteBuf xorSeedBuf = channel.alloc().buffer(4);
        xorSeedBuf.writeInt(this.encryptXor);
        channel.write((Object)xorSeedBuf).addListener((GenericFutureListener)((ChannelFutureListener)future -> this.logger.log(() -> "magic send status:" + future.isSuccess())));
        boolean supportPty = SessionManager.supportSession(PackageType.SESSION_INIT_PTY);
        boolean supportRedial = CtrManager.supportCtrAction("redial");
        ClientRegister clientRegister = new ClientRegister(this.majoraClient.getClientId(), this.majoraClient.getExtra(), this.encryptXor, this.majoraClient.getEndpointGroup(), supportPty, supportRedial, Env.platform, Env.osVersion, "1.0.0", "");
        this.logger.log(() -> "send register pkg:" + clientRegister);
        channel.writeAndFlush((Object)clientRegister).addListener((GenericFutureListener)((ChannelFutureListener)future -> {
            if (!future.isSuccess()) {
                this.logger.log(() -> "send register pkg failed ", future.cause());
                return;
            }
            this.logger.log(() -> "send register pkg success");
            this.invokeOnConnected();
        }));
    }

    protected void channelRead0(ChannelHandlerContext ctx, IProto iProto) throws Exception {
        if (iProto instanceof HeartBeat) {
            this.logger.log(() -> "heartbeat from server");
            HeartBeat heartBeat = (HeartBeat)iProto;
            ctx.writeAndFlush((Object)heartBeat);
        } else if (iProto instanceof SessionInit) {
            SessionInit sessionInit = (SessionInit)iProto;
            this.sessionManager.createSession(this.majoraClient, sessionInit);
        } else if (iProto instanceof SessionSignal.SessionClose) {
            SessionSignal.SessionClose sessionClose = (SessionSignal.SessionClose)iProto;
            this.sessionManager.onInboundStreamClose(sessionClose.getSessionId());
        } else if (iProto instanceof SessionPayload) {
            SessionPayload sessionPayload = (SessionPayload)iProto;
            this.sessionManager.onInboundStreamData(sessionPayload);
        } else if (iProto instanceof CtrReq) {
            CtrReq ctrReq = (CtrReq)iProto;
            this.ctrManager.handleCtrReq(ctrReq);
        } else {
            this.logger.log(() -> "unknown proto: " + iProto.getClass());
        }
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof IdleStateEvent) {
            this.logger.log(() -> "channel idle, close to restart");
            ctx.close();
            return;
        }
        super.userEventTriggered(ctx, evt);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        this.logger.log(() -> "exception caught: ", cause);
        ctx.close();
    }

    private void invokeOnConnected() {
        if (this.connectedInvoked) {
            return;
        }
        this.majoraClient.doOnMainThead(() -> {
            this.connectedInvoked = true;
            this.connectionListener.onConnected(this);
        });
    }

    private void invokeOnDisconnected() {
        if (this.disconnectInvoked) {
            return;
        }
        this.majoraClient.doOnMainThead(() -> {
            this.disconnectInvoked = true;
            this.connectionListener.onDisconnected(this);
        });
    }

    public boolean isActive() {
        return this.majoraServerChannel.isActive();
    }

    public void close() {
        this.majoraServerChannel.close();
    }

    void writeToMajora(IProto iProto) {
        if (this.majoraServerChannel.isActive()) {
            this.majoraServerChannel.writeAndFlush((Object)iProto);
        }
    }

    public static interface ConnectionListener {
        public void onConnected(MajoraConnection var1);

        public void onDisconnected(MajoraConnection var1);
    }
}

