/*
 * Decompiled with CFR 0.152.
 */
package cn.iinti.majora3.sdk.client;

import cn.iinti.majora3.sdk.MajoraLogger;
import cn.iinti.majora3.sdk.client.MajoraConnection;
import io.netty.channel.EventLoop;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.util.concurrent.DefaultThreadFactory;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;

public class MajoraClient
implements MajoraConnection.ConnectionListener {
    public static final String CLIENT_VERSION = "1.0.0";
    public static final int HEARTBEAT_INTERVAL = 30;
    private final String clientId;
    private final String serverHost;
    private final int serverPort;
    private String endpointGroup;
    private String extra;
    private MajoraLogger logger = MajoraLogger.nop;
    private int connectionTimeout = 30000;
    private boolean logCodec = false;
    private final int[] reconnectWaitSlot = new int[]{10, 10, 15, 15, 15, 20, 30, 30, 45};
    private int failedCount;
    private MajoraConnection currentConnection;
    private static final NioEventLoopGroup workerGroup = new NioEventLoopGroup(0, (ThreadFactory)new DefaultThreadFactory("majora-client"));
    private static final EventLoop mainLoop = workerGroup.next();
    private boolean isConnecting = false;
    private boolean destroyed = false;

    public MajoraClient(String serverHost, int serverPort, String clientId) {
        this.clientId = clientId;
        this.serverHost = serverHost;
        this.serverPort = serverPort;
    }

    public boolean matchConfig(String serverHost, int serverPort, String endpointGroup, String extra) {
        return serverHost.equals(this.serverHost) && serverPort == this.serverPort && StringUtils.equals((CharSequence)this.endpointGroup, (CharSequence)endpointGroup) && StringUtils.equals((CharSequence)this.extra, (CharSequence)extra);
    }

    public void start() {
        if (this.destroyed) {
            throw new IllegalStateException("the MajoraClient is destroied");
        }
        this.doOnMainThead(() -> {
            if (this.destroyed) {
                return;
            }
            this.logger.log(() -> "begin start connecting");
            if (this.currentConnection != null && this.currentConnection.isActive()) {
                this.logger.log(() -> "current connection always active,skip connect");
                return;
            }
            if (this.isConnecting) {
                this.logger.log(() -> "there is already connecting");
                return;
            }
            this.isConnecting = true;
            new MajoraConnection(this.serverHost, this.serverPort, this.connectionTimeout, this, workerGroup, this, this.logCodec);
        });
    }

    public void reConnect() {
        this.doOnMainThead(() -> {
            if (this.destroyed) {
                return;
            }
            if (this.currentConnection == null || !this.currentConnection.isActive()) {
                return;
            }
            this.currentConnection.close();
        });
    }

    public void destroy() {
        this.doOnMainThead(() -> {
            this.destroyed = true;
            if (this.currentConnection != null) {
                this.currentConnection.close();
            }
        });
    }

    public void doOnMainThead(Runnable runnable) {
        MajoraClient.doOnMainThead0(() -> {
            try {
                runnable.run();
            }
            catch (Exception e) {
                this.logger.log(() -> "execute main loop error", e);
            }
        });
    }

    public static void doOnMainThead0(Runnable runnable) {
        if (mainLoop.inEventLoop()) {
            runnable.run();
        } else {
            mainLoop.execute(runnable);
        }
    }

    @Override
    public void onConnected(MajoraConnection majoraConnection) {
        this.logger.log(() -> "connection established");
        this.isConnecting = false;
        this.failedCount = 0;
        this.currentConnection = majoraConnection;
    }

    @Override
    public void onDisconnected(MajoraConnection majoraConnection) {
        this.isConnecting = false;
        int waitTime = this.failedCount < this.reconnectWaitSlot.length ? this.reconnectWaitSlot[this.failedCount] : 60;
        this.logger.log(() -> "connection disconnected,will wait for " + waitTime + " seconds to reconnect");
        if (!this.destroyed) {
            mainLoop.schedule(this::start, (long)waitTime, TimeUnit.SECONDS);
        }
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getEndpointGroup() {
        return this.endpointGroup;
    }

    public void setEndpointGroup(String endpointGroup) {
        this.endpointGroup = endpointGroup;
    }

    public String getExtra() {
        return this.extra;
    }

    public void setExtra(String extra) {
        this.extra = extra;
    }

    public void setLogger(MajoraLogger logger) {
        this.logger = logger;
    }

    public MajoraLogger getLogger() {
        return this.logger;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public void setLogCodec(boolean logCodec) {
        this.logCodec = logCodec;
    }
}

