/*
 * Decompiled with CFR 0.152.
 */
package cn.iinti.majora3.sdk.client;

import cn.iinti.majora3.sdk.client.MajoraClient;
import cn.iinti.majora3.sdk.client.MajoraConnection;
import cn.iinti.majora3.sdk.proto.CtrReq;
import cn.iinti.majora3.sdk.proto.CtrResp;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;

public class CtrManager {
    public static final String DEFAULT_ACTION_EXECUTE_CMD = "executeCMD";
    public static final String DEFAULT_ACTION_REDIAL = "redial";
    private static final Executor sharedThread = Executors.newSingleThreadExecutor();
    private static final Map<String, CtrHandler> handlers = new HashMap<String, CtrHandler>();
    private final MajoraClient majoraClient;
    private final MajoraConnection mConnection;

    public static void execute(Runnable runnable) {
        sharedThread.execute(runnable);
    }

    public static void registerCtrHandler(String action, CtrHandler handler) {
        handlers.put(action, handler);
    }

    public static boolean supportCtrAction(String action) {
        return handlers.containsKey(action);
    }

    public void handleCtrReq(CtrReq ctrReq) {
        Response response = new Response(ctrReq);
        String ctr = ctrReq.getCtr();
        CtrHandler ctrHandler = handlers.get(ctr);
        if (ctrHandler == null) {
            this.majoraClient.getLogger().log(() -> "no ctr handler for " + ctrReq.getCtr());
            response.failed("no ctr handler for " + ctrReq.getCtr());
            return;
        }
        try {
            this.majoraClient.getLogger().log(() -> "receive cmd:" + ctrReq.getCtr());
            ctrHandler.handle(ctrReq.getRequestMap(), response);
        }
        catch (Throwable t) {
            this.majoraClient.getLogger().log(() -> "ctr handle error", t);
            response.failed(t.getMessage());
        }
    }

    public CtrManager(MajoraClient majoraClient, MajoraConnection mConnection) {
        this.majoraClient = majoraClient;
        this.mConnection = mConnection;
    }

    static {
        CtrManager.registerCtrHandler(DEFAULT_ACTION_EXECUTE_CMD, new ExecuteCmdHandler());
    }

    public class Response {
        private final AtomicBoolean called = new AtomicBoolean(false);
        private final CtrReq req;

        public Response(CtrReq req) {
            this.req = req;
        }

        public void success(Map<String, String> resp) {
            if (!this.called.compareAndSet(false, true)) {
                return;
            }
            CtrResp ctrResp = new CtrResp(this.req.getRequestSessionId(), "", resp);
            CtrManager.this.mConnection.writeToMajora(ctrResp);
        }

        public void failed(String failedMessage) {
            if (!this.called.compareAndSet(false, true)) {
                return;
            }
            CtrResp ctrResp = new CtrResp(this.req.getRequestSessionId(), failedMessage, new HashMap<String, String>());
            CtrManager.this.mConnection.writeToMajora(ctrResp);
        }
    }

    public static interface CtrHandler {
        public void handle(Map<String, String> var1, Response var2);
    }

    private static class ExecuteCmdHandler
    implements CtrHandler {
        private ExecuteCmdHandler() {
        }

        @Override
        public void handle(Map<String, String> request, Response response) {
            String cmd = request.get("cmd");
            if (StringUtils.isBlank((CharSequence)cmd)) {
                response.failed("no param:{cmd} presented");
                return;
            }
            CtrManager.execute(() -> {
                try {
                    ExecuteCmdHandler.doExecuteCmd(cmd, response);
                }
                catch (Exception e) {
                    response.failed(e.getMessage());
                }
            });
        }

        private static void doExecuteCmd(String cmd, Response response) throws Exception {
            Process process = Runtime.getRuntime().exec(cmd);
            boolean finished = process.waitFor(2L, TimeUnit.MINUTES);
            if (!finished) {
                response.failed("command execution timeout");
                return;
            }
            HashMap<String, String> result = new HashMap<String, String>();
            result.put("error", IOUtils.toString((InputStream)process.getErrorStream(), (Charset)StandardCharsets.UTF_8));
            result.put("output", IOUtils.toString((InputStream)process.getInputStream(), (Charset)StandardCharsets.UTF_8));
            response.success(result);
        }
    }
}

