/*
 * Decompiled with CFR 0.152.
 */
package cn.iinti.majora3.sdk.client;

import cn.iinti.majora3.sdk.MajoraLogger;
import cn.iinti.majora3.sdk.client.MajoraClient;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class ClusterMajoraClient {
    private final String clientId;
    private final List<MajoraClient> majoraClients = new ArrayList<MajoraClient>();

    public ClusterMajoraClient(String clientId, String serverList) {
        this.clientId = clientId;
        HashSet<String> duplicate = new HashSet<String>();
        for (String serverConfig : serverList.trim().split(",")) {
            if (duplicate.contains(serverConfig = serverConfig.trim())) continue;
            duplicate.add(serverConfig);
            String[] hostAndPort = serverConfig.split(":");
            this.majoraClients.add(new MajoraClient(hostAndPort[0], Integer.parseInt(hostAndPort[1]), clientId));
        }
    }

    public ClusterMajoraClient start() {
        this.majoraClients.forEach(MajoraClient::start);
        return this;
    }

    public ClusterMajoraClient restart() {
        this.majoraClients.forEach(MajoraClient::reConnect);
        return this;
    }

    public ClusterMajoraClient setLogCodec(boolean enable) {
        this.majoraClients.forEach(majoraClient -> majoraClient.setLogCodec(enable));
        return this;
    }

    public ClusterMajoraClient setEndpointGroup(String group) {
        this.majoraClients.forEach(majoraClient -> majoraClient.setEndpointGroup(group));
        return this;
    }

    public ClusterMajoraClient setLogger(MajoraLogger logger) {
        this.majoraClients.forEach(majoraClient -> majoraClient.setLogger(logger));
        return this;
    }

    public String getClientId() {
        return this.clientId;
    }
}

