/*
 * Decompiled with CFR 0.152.
 */
package cn.iinti.majora3.sdk.client;

import cn.iinti.majora3.sdk.FailedChannel;
import cn.iinti.majora3.sdk.client.MajoraClient;
import cn.iinti.majora3.sdk.client.SessionManager;
import cn.iinti.majora3.sdk.proto.SessionInit;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import io.netty.channel.DefaultChannelPromise;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.embedded.EmbeddedChannel;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public abstract class BIOStreamSessionFactory<T extends SessionInit>
implements SessionManager.SessionFactory<T> {
    @Override
    public ChannelFuture createSession(MajoraClient client, T sessionInit, SimpleChannelInboundHandler<ByteBuf> channelHandler) {
        IOPair ioPair;
        try {
            ioPair = this.create(sessionInit);
        }
        catch (Throwable e) {
            return FailedChannel.newFailedChannel(e);
        }
        EmbeddedChannel embeddedChannel = new EmbeddedChannel(new ChannelHandler[]{channelHandler, new ChannelOutboundHandlerAdapter(){

            public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
                if (msg instanceof ByteBuf) {
                    ByteBuf byteBuf = (ByteBuf)msg;
                    try {
                        byteBuf.readBytes(ioPair.outputStream, byteBuf.readableBytes());
                        promise.trySuccess();
                    }
                    catch (Throwable e) {
                        promise.setFailure(e);
                    }
                    return;
                }
                super.write(ctx, msg, promise);
            }
        }});
        new Thread(() -> {
            try {
                while (true) {
                    byte[] bytes = new byte[4096];
                    int count = ioPair.inputStream.read(bytes);
                    if (count < 0) {
                        embeddedChannel.finish();
                        break;
                    }
                    embeddedChannel.writeInbound(new Object[]{Unpooled.wrappedBuffer((byte[])bytes, (int)0, (int)count)});
                }
            }
            catch (IOException e) {
                embeddedChannel.pipeline().fireExceptionCaught((Throwable)e);
                embeddedChannel.finish();
            }
        }).start();
        return new DefaultChannelPromise((Channel)embeddedChannel).setSuccess();
    }

    protected abstract IOPair create(T var1) throws Throwable;

    public static class IOPair {
        private final InputStream inputStream;
        private final OutputStream outputStream;

        public IOPair(InputStream inputStream, OutputStream outputStream) {
            this.inputStream = inputStream;
            this.outputStream = outputStream;
        }
    }
}

