/*
 * Decompiled with CFR 0.152.
 */
package cn.iinti.majora3.sdk;

import java.util.function.Supplier;

public interface MajoraLogger {
    public static final MajoraLogger nop = new MajoraLogger(){};
    public static final MajoraLogger consoleLog = new MajoraLogger(){

        @Override
        public void log(Supplier<String> msg) {
            System.out.println(msg.get());
        }

        @Override
        public void log(Supplier<String> msg, Throwable e) {
            System.out.println(msg.get());
            if (e != null) {
                e.printStackTrace(System.err);
            }
        }

        @Override
        public boolean enable() {
            return true;
        }
    };

    default public void log(Supplier<String> msg) {
    }

    default public void log(Supplier<String> msg, Throwable e) {
    }

    default public boolean enable() {
        return false;
    }
}

